clear
capture log close
log using "ConflictsOverSharedRivers.log", replace

/* This do-file replicates results published in                                                     */
/* Nils Petter Gleditsch, Kathryn Furlong, Hvard Hegre, Bethany Lacina & Taylor Owen, 2006         */
/* 'Conflicts over shared rivers: Resource scarcity or fuzzy boundaries?'                           */
/* Political Geography 25:000-000 	                                                                */

/* The do-file starts out with an analysis of all dyads (not only same-continent dyads)             */
/* This analysis is labeled "Part A" below. These results are not reported in the printed article   */
/* Part B analyses only the same-continent dyads                                                    */
/* These results are reported in the article.                                                       */
/* Part A uses the dataset called 'riversiv.dta', Part B the one called 'riversshort.dta'           */



set mem 200m
set matsize 400

/* Part A: Analysis with all dyads (not reported in article)                                       */
use "riversiv.dta", clear

/* Regenerating "dry" variable, creating interaction terms */
replace rainfallhh_1 = . if rainfallhh_1 == -9999
replace rainfallhh_2 = . if rainfallhh_2 == -9999

capture drop anydryhh
gen anydryhh = .
replace anydryhh = 0 if rainfallhh_1 > 619 & rainfallhh_2 > 619
replace anydryhh = 1 if rainfallhh_1 <= 619 | rainfallhh_2 <= 619
capture drop anydryhh_sharedbasin
capture drop anydryhh_lntotalbasin

gen anydryhh_sharedbasin = anydryhh*sharedbasin
gen anydryhh_lntotalbasin = anydryhh*lntotalbasin

tab anydry anydryhh
tab anydryhh sharedbasin

capture drop meandry
gen meandry = (rainfallhh_1 + rainfallhh_2)/2
capture drop meandry_sharedbasin
gen meandry_sharedbasin = meandry*sharedbasin


summarize rainfall* meandry, detail

/* Bivariate replication */

logit fmidonset onedemoc, cluster(dyadid)
logit fmidonset twoautoc, cluster(dyadid)
logit fmidonset sharedbasin, cluster(dyadid)
logit fmidonset riverboundary, cluster(dyadid)
logit fmidonset rivercross, cluster(dyadid)
logit fmidonset lntotalbasin, cluster(dyadid)
logit fmidonset lnbasinupstream, cluster(dyadid)
logit fmidonset percupstream, cluster(dyadid)
logit fmidonset anydry, cluster(dyadid)
logit fmidonset droughtlag, cluster(dyadid)
logit fmidonset lndyaddevelop, cluster(dyadid)
logit fmidonset mideastnaf, cluster(dyadid)
logit fmidonset ssa, cluster(dyadid)

/* Coding extinct nations */
replace contcnt1 = 4 if ccode1 == 245
replace contcnt2 = 4 if ccode2 == 245
replace contcnt1 = 4 if ccode1 == 240
replace contcnt2 = 4 if ccode2 == 240
replace contcnt1 = 4 if ccode1 == 267
replace contcnt2 = 4 if ccode2 == 267
replace contcnt1 = 4 if ccode1 == 269
replace contcnt2 = 4 if ccode2 == 269
replace contcnt1 = 4 if ccode1 == 271
replace contcnt2 = 4 if ccode2 == 271
replace contcnt1 = 4 if ccode1 == 273
replace contcnt2 = 4 if ccode2 == 273
replace contcnt1 = 4 if ccode1 == 275
replace contcnt2 = 4 if ccode2 == 275
replace contcnt1 = 4 if ccode1 == 300
replace contcnt2 = 4 if ccode2 == 300
replace contcnt1 = 4 if ccode1 == 327
replace contcnt2 = 4 if ccode2 == 327
replace contcnt1 = 4 if ccode1 == 329
replace contcnt2 = 4 if ccode2 == 329
replace contcnt1 = 4 if ccode1 == 337
replace contcnt2 = 4 if ccode2 == 337

replace contcnt1 = 5 if ccode1 == 730
replace contcnt1 = 5 if ccode2 == 730

replace noofcountries = 20 if contcnt1 == 4 & year >= 1816 & year <= 1827
replace noofcountries = 21 if contcnt1 == 4 & year >= 1828 & year <= 1829
replace noofcountries = 22 if contcnt1 == 4 & year >= 1830 & year <= 1837
replace noofcountries = 23 if contcnt1 == 4 & year >= 1838 & year <= 1854
replace noofcountries = 24 if contcnt1 == 4 & year >= 1855 & year <= 1860
replace noofcountries = 21 if contcnt1 == 4 & year >= 1861 & year <= 1866
replace noofcountries = 19 if contcnt1 == 4 & year == 1867
replace noofcountries = 17 if contcnt1 == 4 & year >= 1868 & year <= 1871
replace noofcountries = 14 if contcnt1 == 4 & year >= 1872 & year <= 1877
replace noofcountries = 16 if contcnt1 == 4 & year >= 1878 & year <= 1904
replace noofcountries = 17 if contcnt1 == 4 & year == 1905

replace noofcountries = 3 if contcnt1 == 5 & year >= 1887 & year <= 1905

/* Log-transforming river boundareis */
capture drop lnriverboundary
gen lnriverboundary = riverboundary
replace lnriverboundary = ln(riverboundary) if riverboundary > 0
summarize lnriverboundary, detail


/* Limiting sample */
capture drop validobs
gen validobs = 1
replace validobs = 0 if sislcnt1 == -1 | sislcnt2 == -1
replace validobs = 0 if contcnt1 != contcnt2
/* Include Turkey and Russia in both continents */
replace validobs = 1 if ccode1==365 & contcnt2 == 5
replace validobs = 1 if ccode2==365 & contcnt1 == 5
replace validobs = 1 if ccode1==640 & contcnt2 == 5
replace validobs = 1 if ccode2==640 & contcnt1 == 5

/* Creating system size variable */

capture drop syssize
gen syssize = .
replace syssize = 0 if contiguity == 1
replace syssize = -ln(noofcountries) if contiguity == 0
summ syssize, detail


tab validobs
drop if validobs == 0


/* Part B: Same-continent dyads only. Results as reported in article                   */

use "riversshort2.dta", clear



/* Delimiting to 1880- period */
logit fmidonset onedemoc if year >=1880, cluster(dyadid)
logit fmidonset twoautoc if year >=1880, cluster(dyadid)
logit fmidonset sharedbasin if year >=1880, cluster(dyadid)
logit fmidonset riverboundary if year >=1880, cluster(dyadid)
logit fmidonset lnriverboundary if year >=1880, cluster(dyadid)
logit fmidonset rivercross if year >=1880, cluster(dyadid)
logit fmidonset lntotalbasin if year >=1880, cluster(dyadid)
logit fmidonset lnbasinupstream if year >=1880, cluster(dyadid)
logit fmidonset percupstream if year >=1880, cluster(dyadid)
logit fmidonset anydryhh if year >=1880, cluster(dyadid)
logit fmidonset droughtlag if year >=1880, cluster(dyadid)
logit fmidonset lndyaddevelop if year >=1880, cluster(dyadid)
logit fmidonset mideastnaf if year >=1880, cluster(dyadid)
logit fmidonset ssa if year >=1880, cluster(dyadid)
logit fmidonset syssize if year >=1880, cluster(dyadid)


summ ccode1 if contcnt1 == .
replace contcnt1 = 4 if ccode1 == 221
replace contcnt2 = 4 if ccode2 == 221

replace contcnt1 = . if ccode1 == 860 | ccode1 == 946 | ccode1 == 947 | ccode1 == 955 | ccode1 == 970
replace contcnt2 = . if ccode2 == 860 | ccode2 == 946 | ccode2 == 947 | ccode2 == 955 | ccode2 == 970

drop if contcnt1==. | contcnt2==.

save "P:\Articles\Rivers\Rivers IV\Stata\riversshort2.dta", replace



/* Table II */
/* Model 1 */
logit fmidonset peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower alliance lndistance contiguity lnboundary postcw syssize if year >=1880, cluster(dyadid)
/* MOdel 2 */
logit fmidonset peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

/* Table III */
/* Model 1 */
logit fmidonset sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

/* Model 2 */
logit fmidonset riverboundary peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)
logit fmidonset lnriverboundary peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

/* Model 3 */
logit fmidonset rivercross peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

/* Model 4 */
logit fmidonset lntotalbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

/* Model 5 */
logit fmidonset lnbasinupstream peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

/* Model 6 */
logit fmidonset percupstream peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)


/* Model 7; with meandry and shared basin rather than basin size */
logit fmidonset sharedbasin meandry meandry_sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

/* ll ratio test for set of dryness variables */
logit fmidonset sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if meandry != . & year >=1880
logit fmidonset sharedbasin meandry meandry_sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880
/* Model 8 */
logit fmidonset droughtlag droughtlag_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

logit fmidonset droughtlag droughtlag_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880
logit fmidonset sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if droughtlag !=. & year >=1880


/* Model 9 */
logit fmidonset ssa ssa_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

logit fmidonset ssa ssa_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880
logit fmidonset sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if ssa !=. & year >=1880


/* Model 10 */
logit fmidonset mideastnaf mideastnaf_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

logit fmidonset mideastnaf mideastnaf_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880
logit fmidonset sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if mideastnaf !=. & year >=1880



/* Model 11 */
logit fmidonset lndyaddevelop lnsqdyaddevelop dd_sharedbasin ddsq_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

logit fmidonset lndyaddevelop lnsqdyaddevelop dd_sharedbasin ddsq_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880
logit fmidonset sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if lndyaddevelop !=. & year >=1880

logit fmidonset lndyaddevelop dd_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880



/*Clarifying */
summ fmidonset riverboundary peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880 & riverboundary !=.


/* Model 3 */
capture drop b*
estsimp logit fmidonset riverboundary peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)
setx riverboundary 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi

setx riverboundary 1 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi


/* Model 4 */
capture drop b*
estsimp logit fmidonset lntotalbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)
setx lntotalbasin p10 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi

setx lntotalbasin p90 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi


/* Model 5 */
capture drop b*
estsimp logit fmidonset lnbasinupstream peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)
setx lnbasinupstream p10 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi

setx lnbasinupstream p90 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi

/* Model 6 */
capture drop b*
estsimp logit fmidonset percupstream peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)
setx percupstream p10 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi

setx percupstream p90 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi


/* Table IV */

/* Model 7; with meandry and shared basin rather than basin size */
capture drop b*
estsimp logit fmidonset sharedbasin meandry meandry_sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

/* Using 10, 50, 90 percentiles for meandry, 0 , 1 for sharedbasin */
setx sharedbasin 0 meandry 405 meandry_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi
setx sharedbasin 0 meandry 838 meandry_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi
setx sharedbasin 0 meandry 1612 meandry_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi
setx sharedbasin 1 meandry 405 meandry_sharedbasin 405 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi
setx sharedbasin 1 meandry 838 meandry_sharedbasin 838 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi
setx sharedbasin 1 meandry 1612 meandry_sharedbasin 1612 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi



/* Model 8 */
logit fmidonset droughtlag droughtlag_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)


/* Model 11 */
logit fmidonset lndyaddevelop lnsqdyaddevelop dd_sharedbasin ddsq_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

/* Model 9 */
logit fmidonset mideastnaf mideastnaf_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)


/* Model 10 */
logit fmidonset ssa ssa_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc lndyaddevelop dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)


/* Figure 3/ Model 11; effect of development */
/* lr test */
logit fmidonset lndyaddevelop lnsqdyaddevelop dd_sharedbasin ddsq_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc dyadsize majorpower lndistance lnboundary if year >=1880
estimates store full
logit fmidonset lndyaddevelop dd_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc dyadsize majorpower lndistance lnboundary if year >=1880
lrtest full



capture drop b*
estsimp logit fmidonset lndyaddevelop lnsqdyaddevelop dd_sharedbasin ddsq_sharedbasin sharedbasin peacehistory unconsolidated onedemoc twoautoc dyadsize majorpower lndistance lnboundary if year >=1880, cluster(dyadid)

/* Using values at .5 intervals from -4 to 2 for dyaddevelopment; 0 , 1 for sharedbasin */
/* No shareed basin */
setx sharedbasin 0 lndyaddevelop -4 lnsqdyaddevelop 16 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 0 lndyaddevelop -3.5 lnsqdyaddevelop 12.25 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 0 lndyaddevelop -3 lnsqdyaddevelop 9 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 0 lndyaddevelop -2.5 lnsqdyaddevelop 6.25 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 0 lndyaddevelop -2 lnsqdyaddevelop 4 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 0 lndyaddevelop -1.5 lnsqdyaddevelop 2.25 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 0 lndyaddevelop -1 lnsqdyaddevelop 1 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 0 lndyaddevelop -0.5 lnsqdyaddevelop 0.25 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 0 lndyaddevelop 0 lnsqdyaddevelop 0 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 0 lndyaddevelop 0.5 lnsqdyaddevelop 0.25 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 0 lndyaddevelop 1 lnsqdyaddevelop 1 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 0 lndyaddevelop 1.5 lnsqdyaddevelop 2.25 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 0 lndyaddevelop 2 lnsqdyaddevelop 4 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)

/* Shared basin */
setx sharedbasin 1 lndyaddevelop -4 lnsqdyaddevelop 16 dd_sharedbasin -4 ddsq_sharedbasin 16 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 1 lndyaddevelop -3.5 lnsqdyaddevelop 12.25 dd_sharedbasin -3.5 ddsq_sharedbasin 12.25 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 1 lndyaddevelop -3 lnsqdyaddevelop 9 dd_sharedbasin -3 ddsq_sharedbasin 9 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 1 lndyaddevelop -2.5 lnsqdyaddevelop 6.25 dd_sharedbasin -2.5 ddsq_sharedbasin 6.25 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 1 lndyaddevelop -2 lnsqdyaddevelop 4 dd_sharedbasin -2 ddsq_sharedbasin 4 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 1 lndyaddevelop -1.5 lnsqdyaddevelop 2.25 dd_sharedbasin -1.5 ddsq_sharedbasin 2.25 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 1 lndyaddevelop -1 lnsqdyaddevelop 1 dd_sharedbasin -1 ddsq_sharedbasin 1 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 1 lndyaddevelop -0.5 lnsqdyaddevelop 0.25 dd_sharedbasin -0.5 ddsq_sharedbasin 0.25 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 1 lndyaddevelop 0 lnsqdyaddevelop 0 dd_sharedbasin 0 ddsq_sharedbasin 0 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 1 lndyaddevelop 0.5 lnsqdyaddevelop 0.25 dd_sharedbasin 0.5 ddsq_sharedbasin 0.25 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 1 lndyaddevelop 1 lnsqdyaddevelop 1 dd_sharedbasin 1 ddsq_sharedbasin 1 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 1 lndyaddevelop 1.5 lnsqdyaddevelop 2.25 dd_sharedbasin 1.5 ddsq_sharedbasin 2.25 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)
setx sharedbasin 1 lndyaddevelop 2 lnsqdyaddevelop 4 dd_sharedbasin 2 ddsq_sharedbasin 4 peacehistory mean unconsolidated 0 onedemoc 1 twoautoc 0 lndyaddevelop mean dyadsize mean majorpower 0 lndistance mean lnboundary mean
simqi, l(90)


