set more off
set mem 400m

log using "analysis.log", replace

use "inc_sev.dta", clear

label variable prox_conflict_10 "Proximity to Conflict"
label variable lngdpcap "log of Average Income"
label variable lnpop "log of Population"
label variable prox_sip_change_std "Proximity to Regime Change"
label variable censip_std "SIP"
label variable censip_sq_std "SIP, squared"
label variable cen_elf "Ethno-Ling. Fractionalization"
label variable cen_elfsq "Ethno-Ling. Fract., squared"
label variable polityiv_std "Polity IV"
label variable polity_sq_std "Polity IV, squared"
label variable cendiffneigh "Democratic Difference"
label variable cendiffneighsq "Democratic Difference, squared"
label variable election "Election Year"
label variable presidentialism "Presidentialism"
label variable prop "Proportional Representation"
label variable fedpol3 "Federal System"
label variable ethdom "Ethnic Dominance"
label variable cenvanhanen_std "Polyarchy"
label variable cenvanhanensq_std "Polyarchy, squared"
label variable cenfreedomhouse_std "FreedomHouse"
label variable cenfreedomhousesq_std "FreedomHouse, squared"



quietly logistic uppsala_i  prox_sip_change_std polityiv_std sip_std cendiff* election lngdpcap lnpop cen_elf* Oil
capture drop sample
gen sample=e(sample)
sum year if sample==1

quietly logistic uppsala_i fedpol3 prop presidentialism
capture drop sample2
gen sample2=e(sample)
sum year if sample2==1

logistic uppsala_i  polityiv_std  if sample==1
est store incidence_bivariate_1, title(T1_R1_C2)
logistic uppsala_i  polity_sq_std if sample==1
est store incidence_bivariate_2, title(T1_R2_C2)
logistic uppsala_i  censip_std if sample==1
est store incidence_bivariate_3, title(T1_R3_C2)
logistic uppsala_i  censip_sq_std if sample==1
est store incidence_bivariate_4, title(T1_R4_C2)
logistic uppsala_i prox_sip_change_std if sample==1
est store incidence_bivariate_5, title(T1_R5_C2)
logistic uppsala_i cendiffneigh if sample==1
est store incidence_bivariate_6, title(T1_R6_C2)
logistic uppsala_i cendiffneighsq if sample==1
est store incidence_bivariate_7, title(T1_R7_C2)
logistic uppsala_i election if sample==1
est store incidence_bivariate_8, title(T1_R8_C2)
logistic uppsala_i  presidentialism if sample2==1
est store incidence_bivariate_9, title(T1_R9_C2)
logistic uppsala_i prop if sample2==1
est store incidence_bivariate_10, title(T1_R10_C2)
logistic uppsala_i fedpol3 if sample2==1
est store incidence_bivariate_11, title(T1_R11_C2)
logistic uppsala_i cenvanhanen_std if sample==1
est store incidence_bivariate_12, title(T1_R12_C2)
logistic uppsala_i cenvanhanensq_std if sample==1
est store incidence_bivariate_13, title(T1_R13_C2)
logistic uppsala_i cenfreedomhouse_std if sample==1
est store incidence_bivariate_14, title(T1_R14_C2)
logistic uppsala_i cenfreedomhousesq_std if sample==1
est store incidence_bivariate_15, title(T1_R15_C2)
estout incidence_bi* using "incidence_bi.html", cells(b(star fmt(%9.3f)) t(par)) stats(ll ll_0 N N_sub N_fail, fmt(%9.2f %9.2f %9.0g %9.0g %9.0g) labels("Log Likelihood" "Log Likelihood null model" "N" "Number of Countries" "Number of Civil Wars") ) style(html) label replace collabels(, none) starlevels(* 0.1 ** 0.05 *** 0.01) eform prehead("<table>") postfoot("</table>")
est drop *

logistic uppsala_i censip_std censip_sq_std prox_sip_change_std election cendiff* cen_elf* lngdp lnpop lag_u prox_conflict_10 Oil if sample==1
est store incidence_multivariate_2a, title(T3_R2_2)
logistic uppsala_i polityiv_std polity_sq_std prox_sip_change_std election cendiff* cen_elf* lngdp lnpop lag_u prox_conflict_10 Oil if sample==1
est store incidence_multivariate_2b, title(T3_R2_1)
logistic uppsala_i presidentialism prop fedpol3 prox_sip_change_std cendiff* cen_elf* lngdp lnpop lag_u prox_conflict_10 Oil election if sample2==1
est store incidence_multivariate_6, title(T3_R2_3)
estout incidence_multi* using "incidence_multi.html", cells(b(star fmt(%9.3f)) t(par)) stats(ll ll_0 N N_sub N_fail, fmt(%9.2f %9.2f %9.0g %9.0g %9.0g) labels("Log Likelihood" "Log Likelihood null model" "N" "Number of Countries" "Number of Civil Wars") ) style(html) label replace collabels(, none) starlevels(* 0.1 ** 0.05 *** 0.01) eform prehead("<table>") postfoot("</table>")
est drop *

quietly regress lnbattdeath censip_std censip_sq_std prox_sip_change_std cendiff* cen_elf* lngdp lnpop election Oil laglnb
capture drop sample
gen sample=e(sample)
sum year if sample==1

quietly regress lnbattdeath  presidentialism prop fedpol3 cen_elf* lngdp lnpop laglnb
capture drop sample2
gen sample2=e(sample)
sum year if sample2==1

regress lnbattdeath laglnb polityiv_std  if sample==1
est store severity_bivariate_1, title(T1_R1_C4)
regress lnbattdeath polity_sq_std laglnb if sample==1
est store severity_bivariate_2, title(T1_R2_C4)
regress lnbattdeath sip_std laglnb if sample==1
est store severity_bivariate_3, title(T1_R3_C4)
regress lnbattdeath censip_sq_std laglnb if sample==1
est store severity_bivariate_4 , title(T1_R4_C4)
regress lnbattdeath prox_sip_change_std laglnb if sample==1
est store severity_bivariate_5, title(T1_R5_C4)
regress lnbattdeath cendiffneigh laglnb if sample==1
est store severity_bivariate_6, title(T1_R6_C4)
regress lnbattdeath cendiffneighsq laglnb if sample==1
est store severity_bivariate_7, title(T1_R7_C4)
regress lnbattdeath election laglnb if sample==1
est store severity_bivariate_8, title(T1_R8_C4)
regress lnbattdeath presidentialism laglnb if sample2==1
est store severity_bivariate_9, title(T1_R9_C4)
regress lnbattdeath prop laglnb if sample2==1
est store severity_bivariate_10, title(T1_R10_C4)
regress lnbattdeath fedpol3 laglnb if sample2==1
est store severity_bivariate_11, title(T1_R11_C4)
regress lnbattdeath cenvanhanen_std laglnb if sample==1
est store severity_bivariate_12, title(T1_R12_C4)
regress lnbattdeath cenvanhanensq_std laglnb if sample==1
est store severity_bivariate_13, title(T1_R13_C4)
regress lnbattdeath cenfreedomhouse_std laglnb if sample==1
est store severity_bivariate_14, title(T1_R14_C4)
regress lnbattdeath cenfreedomhousesq_std laglnb if sample==1
est store severity_bivariate_15, title(T1_R15_C4)
estout severity_bi* using "severity_bi.html", cells(b(star fmt(%9.3f)) t(par)) stats(ll ll_0 N N_sub N_fail, fmt(%9.2f %9.2f %9.0g %9.0g %9.0g) labels("Log Likelihood" "Log Likelihood null model" "N" "Number of Countries" "Number of Civil Wars") ) style(html) label replace collabels(, none) starlevels(* 0.1 ** 0.05 *** 0.01) eform prehead("<table>") postfoot("</table>")
est drop *

regress lnbattdeath censip_std censip_sq_std prox_sip_change_std cendiff* cen_elf* lngdp lnpop election Oil laglnb if sample==1
est store severity_multivariate_1b, title(T3_R4_2)
regress lnbattdeath polityiv_std polity_sq_std prox_sip_change_std cendiff* cen_elf* lngdp lnpop election Oil laglnb if sample==1
est store severity_multivariate_2, title(T3_R4_1)
regress lnbattdeath  presidentialism prop fedpol3 cen_elf* lngdp lnpop Oil cendiff* election prox_sip_change_std laglnb if sample==1
est store severity_multivariate_6, title(T3_R4_3)
estout severity_multi* using "severity_multi.html", cells(b(star fmt(%9.3f)) t(par)) stats(ll ll_0 N N_sub N_fail, fmt(%9.2f %9.2f %9.0g %9.0g %9.0g) labels("Log Likelihood" "Log Likelihood null model" "N" "Number of Countries" "Number of Civil Wars") ) style(html) label replace collabels(, none) starlevels(* 0.1 ** 0.05 *** 0.01) eform prehead("<table>") postfoot("</table>")
est drop *

use "onset.dta", clear

label variable prox_conflict10_1 "Proximity to Conflict"
label variable lngdpcap "log of Average Income"
label variable lnpop "log of Population"
label variable prox_sip_change_std "Proximity to Regime Change"
label variable censip_std "SIP"
label variable censip_sq_std "SIP, squared"
label variable cen_elf "Ethno-Ling. Fractionalization"
label variable cen_elfsq "Ethno-Ling. Fract., squared"
label variable polityiv_std "Polity IV"
label variable polity_sq_std "Polity IV, squared"
label variable demnabo "Democratic Neighborhood"
label variable cendiffneigh "Democratic Difference"
label variable cendiffneighsq "Democratic Difference, squared"
label variable prox_election_05 "Proximity to Election"
label variable presidentialism "Presidentialism"
label variable prop "Proportional Representation"
label variable fedpol3 "Federal System"
label variable first "First Year After Independece"
label variable ethdom "Ethnic Dominance"
label variable prox_sip2 "Proximity to Regime Change"
label variable cenvanhanen_std "Polyarchy"
label variable cenvanhanensq_std "Polyarchy, squared"
label variable cenfreedomhouse_std "FreedomHouse"
label variable cenfreedomhousesq_std "FreedomHouse, squared"

quietly stcox polityiv_std polity_sq_std censip_std censip_sq_std prox_sip2 prox1 prox2 cendiff* lngdpcap lnpop dw cen_elf* prox_conflict10_1 first Oil
capture drop sample
gen sample=e(sample)
sum year if sample==1
sort eventdate
by eventdate: egen includedonset=mean(onset) if sample==1
replace sample=0 if includedonset==0

stcox polityiv_std if sample==1
est store onset_bivariate_1, title(T1_R1_C1)
stcox polity_sq_std if sample==1
est store onset_bivariate_2, title(T1_R2_C1)
stcox sip_std if sample==1
est store onset_bivariate_3, title(T1_R3_C1)
stcox censip_sq_std if sample==1
est store onset_bivariate_4, title(T1_R4_C1)
stcox prox_sip_change_std if sample==1
est store onset_bivariate_5, title(T1_R5_C1)
stcox prox1 if sample==1
est store onset_bivariate_6, title(T1_R6_C1)
stcox cendiffneigh if sample==1
est store onset_bivariate_7, title(T1_R7_C1)
stcox cendiffneighsq if sample==1
est store onset_bivariate_8, title(T1_R8_C1)
stcox president if regime_leg==0
est store onset_bivariate_10, title(T1_R9_C1)
stcox prop if regime_leg==0
est store onset_bivariate_11, title(T1_R10_C1)
stcox fedpol3 if regime_leg==0
est store onset_bivariate_12, title(T1_R11_C1)
stcox cenvanhanen_std if sample==1
est store onset_bivariate_13, title(T1_R12_C1)
stcox cenvanhanensq_std if sample==1
est store onset_bivariate_14, title(T1_R13_C1)
stcox cenfreedomhouse_std if sample==1
est store onset_bivariate_15, title(T1_R14_C1)
stcox cenfreedomhousesq_std if sample==1
est store onset_bivariate_16, title(T1_R15_C1)

estout onset_bi* using "onset_bi.html", cells(b(star fmt(%9.3f)) t(par)) stats(ll ll_0 N N_sub N_fail, fmt(%9.2f %9.2f %9.0g %9.0g %9.0g) labels("Log Likelihood" "Log Likelihood null model" "N" "Number of Countries" "Number of Civil Wars") ) style(html) label replace collabels(, none) starlevels(* 0.1 ** 0.05 *** 0.01) eform prehead("<table>") postfoot("</table>")
est drop *

stcox sip_std prox_sip_change_std  if sample==1
est store onset_trivariate_1, title(T2_R2_C1)
stcox censip_sq_std prox_sip_change_std  if sample==1
est store onset_trivariate_2, title(T2_R2_C2)
stcox cendiffneighsq prox_sip_change_std  if sample==1
est store onset_trivariate_3, title(T2_R2_C3)
stcox prox1 prox_sip_change_std  if sample==1
est store onset_trivariate_4, title(T2_R2_C4)

stcox sip_std if rich==1 & sample==1
est store onset_trivariate_5, title(T2_R3_C1)
stcox censip_sq_std if rich==1 & sample==1
est store onset_trivariate_6, title(T2_R3_C2)
stcox cendiffneighsq if rich==1 & sample==1
est store onset_trivariate_7, title(T2_R3_C3)
stcox prox1 if rich==1 & sample==1
est store onset_trivariate_8, title(T2_R3_C4)

stcox sip_std if rich==0 & sample==1
est store onset_trivariate_9, title(T2_R4_C1)
stcox censip_sq_std if rich==0 & sample==1
est store onset_trivariate_10, title(T2_R4_C2)
stcox cendiffneighsq if rich==0 & sample==1
est store onset_trivariate_11, title(T2_R4_C3)
stcox prox1 if rich==0 & sample==1
est store onset_trivariate_12, title(T2_R4_C4)
estout onset_tri* using "onset_tri1.html", cells(b(star fmt(%9.3f)) t(par)) stats(ll ll_0 N N_sub N_fail, fmt(%9.2f %9.2f %9.0g %9.0g %9.0g) labels("Log Likelihood" "Log Likelihood null model" "N" "Number of Countries" "Number of Civil Wars") ) style(html) label replace collabels(, none) starlevels(* 0.1 ** 0.05 *** 0.01) eform prehead("<table>") postfoot("</table>")
est drop *

stcox sip_std if incomp==1 & sample==1
est store onset_trivariate_13, title(T2_R5_C1)
stcox censip_sq_std if incomp==1 & sample==1
est store onset_trivariate_14, title(T2_R5_C2)
stcox cendiffneighsq if incomp==1 & sample==1
est store onset_trivariate_15, title(T2_R5_C3)
stcox prox1 if incomp==1 & sample==1
est store onset_trivariate_16, title(T2_R5_C4)
 
stcox sip_std if incomp==2 & sample==1
est store onset_trivariate_17, title(T2_R6_C1)
stcox censip_sq_std if incomp==2 & sample==1
est store onset_trivariate_18, title(T2_R6_C2)
stcox cendiffneighsq if incomp==2 & sample==1
est store onset_trivariate_19, title(T2_R6_C3)
stcox prox1 if incomp==2 & sample==1
est store onset_trivariate_20, title(T2_R6_C4)

stcox sip_std if coldwar==1 & sample==1
est store onset_trivariate_21, title(T2_R7_C1)
stcox censip_sq_std if coldwar==1 & sample==1
est store onset_trivariate_22, title(T2_R7_C2)
stcox cendiffneighsq if coldwar==1 & sample==1
est store onset_trivariate_23, title(T2_R7_C3)
stcox prox1 if coldwar==1 & sample==1
est store onset_trivariate_24, title(T2_R7_C4)

stcox sip_std if coldwar==0 & sample==1
est store onset_trivariate_25, title(T2_R8_C1)
stcox censip_sq_std if coldwar==0 & sample==1
est store onset_trivariate_26, title(T2_R8_C2)
stcox cendiffneighsq if coldwar==0 & sample==1
est store onset_trivariate_27, title(T2_R8_C3)
stcox prox1 if coldwar==0 & sample==1
est store onset_trivariate_28, title(T2_R8_C4)
estout onset_tri* using "onset_tri2.html", cells(b(star fmt(%9.3f)) t(par)) stats(ll ll_0 N N_sub N_fail, fmt(%9.2f %9.2f %9.0g %9.0g %9.0g) labels("Log Likelihood" "Log Likelihood null model" "N" "Number of Countries" "Number of Civil Wars") ) style(html) label replace collabels(, none) starlevels(* 0.1 ** 0.05 *** 0.01) eform prehead("<table>") postfoot("</table>")
est drop *

stcox polityiv_std polity_sq_std prox_sip29 prox_indep29 cendiffneigh* lngdpcap lnpop prox_conflict7_1 cen_elf* Oil prox1 prox2 if sample==1, robust
est store onset_multivariate_1, title(Table_III_1)
stcox president prop fedpol3 prox_sip29 prox_indep29 lngdpcap lnpop dw cen_elf* prox_conflict7_1 Oil prox1 prox2 if regime_leg==0 & sample==1, robust
est store onset_multivariate_6, title(Table_III_2)
estout onset_multi* using "onset_multi3.html", cells(b(star fmt(%9.3f)) t(par)) stats(ll ll_0 N N_sub N_fail, fmt(%9.2f %9.2f %9.0g %9.0g %9.0g) labels("Log Likelihood" "Log Likelihood null model" "N" "Number of Countries" "Number of Civil Wars") ) style(html) label replace collabels(, none) starlevels(* 0.1 ** 0.05 *** 0.01) eform prehead("<table>") postfoot("</table>")
est drop *

stcox censip_std censip_sq_std prox_sip29 lngdpcap lnpop prox_conflict7_1 cen_elf* Oil if sample==1, robust
est store onset_multivariate_2, title(Model 1)
stcox censip_std censip_sq_std prox_sip29 prox_indep29 cendiffneigh* lngdpcap lnpop prox_conflict7_1 cen_elf* Oil prox1 prox2 if sample==1, robust
est store onset_multivariate_3, title(Model 2)
stcox censip_std censip_sq_std prox_sip29 prox_indep29 cendiffneigh* lngdpcap lnpop prox_conflict7_1 cen_elf* Oil prox1 prox2 if sample==1 & intensity>0 & intermittent_period_1>(8*365.25), robust
est store onset_multivariate_4, title(Model 3)
stcox censip_std censip_sq_std prox_sip29 prox_indep29 cendiffneigh* lngdpcap lnpop prox_conflict7_2 cen_elf* Oil prox1 prox2 if sample==1 & intensity>1, robust
est store onset_multivariate_5, title(Model 4)
estout onset_multi* using "onset_multi4.html", cells(b(star fmt(%9.3f)) t(par)) stats(ll ll_0 N N_sub N_fail, fmt(%9.2f %9.2f %9.0g %9.0g %9.0g) labels("Log Likelihood" "Log Likelihood null model" "N" "Number of Countries" "Number of Civil Wars") ) style(html) label replace collabels(, none) starlevels(* 0.1 ** 0.05 *** 0.01) eform prehead("<table>") postfoot("</table>")
est drop *



use "duration.dta", clear

label variable lngdpcap "log of Average Income"
label variable lnpop "log of Population"
label variable prox_sip_change_std "Proximity to Regime Change"
label variable censip_std "SIP"
label variable censip_sq_std "SIP, squared"
label variable cenelf "Ethno-Ling. Fractionalization"
label variable cenelfsq "Ethno-Ling. Fract., squared"
label variable polityiv_std "Polity IV"
label variable polity_sq_std "Polity IV, squared"
label variable demnabo "Democratic Neighborhood"
label variable cendiffneigh "Democratic Difference"
label variable cendiffneighsq "Democratic Difference, squared"
label variable election "Election Year"
label variable presidentialism "Presidentialism"
label variable prop "Proportional Representation"
label variable fedpol3 "Federal System"
label variable first "First Year After Independece"
label variable ethdom "Ethnic Dominance"
label variable cenvanhanen_std "Polyarchy"
label variable cenvanhanensq_std "Polyarchy, squared"
label variable cenfreedomhouse_std "FreedomHouse"
label variable cenfreedomhousesq_std "FreedomHouse, squared"

quietly streg incompatibility polityiv_std type censip_* prox_sip_change_std election cendiff* lngdpcap lnpop Oil cenelf*, dist(wei) tr
capture drop sample
gen sample=e(sample)
sum year if sample==1

quietly streg presidential prop fedpol3 election cendiff* lngdpcap lnpop Oil cenelf*, dist(wei) tr
capture drop sample2
gen sample2=e(sample)
sum year if sample2==1

streg polityiv_std if sample==1, dist(wei) tr
est store duration_bivariate_1, title(T1_R1_C3)
streg polity_sq_std if sample==1, dist(wei) tr
est store duration_bivariate_2, title(T1_R2_C3)
streg censip_std if sample==1, dist(wei) tr
est store duration_bivariate_3, title(T1_R3_C3)
streg censip_sq_std if sample==1, dist(wei) tr
est store duration_bivariate_4, title(T1_R4_C3)
streg prox_sip_change_std if sample==1, dist(wei) tr
est store duration_bivariate_5, title(T1_R5_C3)
streg election if sample==1, dist(wei) tr
est store duration_bivariate_7, title(T1_R6_C3)
streg cendiffneigh if sample==1, dist(wei) tr
est store duration_bivariate_6a, title(T1_R7_C3)
streg cendiffneighsq if sample==1, dist(wei) tr
est store duration_bivariate_6b, title(T1_R8_C3)
streg presidentialism if regime_leg==0 & sample2==1, dist(wei) tr
est store duration_bivariate_8, title(T1_R9_C3)
streg prop if regime_leg==0  & sample2==1, dist(wei) tr
est store duration_bivariate_9, title(T1_R10_C3)
streg fedpol3 if regime_leg==0 & sample2==1, dist(wei) tr
est store duration_bivariate_10, title(T1_R11_C3)
streg cenvanhanen_std if sample==1, dist(wei) tr
est store duration_bivariate_11, title(T1_R12_C3)
streg cenvanhanensq_std if sample==1, dist(wei) tr
est store duration_bivariate_12, title(T1_R13_C3)
streg cenfreedomhouse_std if sample==1, dist(wei) tr
est store duration_bivariate_13, title(T1_R14_C3)
streg cenfreedomhousesq_std if sample==1, dist(wei) tr
est store duration_bivariate_14, title(T1_R15_C3)

estout duration_bi* using "duration_bi.html", cells(b(star fmt(%9.3f)) t(par)) stats(ll ll_0 N N_sub N_fail, fmt(%9.2f %9.2f %9.0g %9.0g %9.0g) labels("Log Likelihood" "Log Likelihood null model" "N" "Number of Countries" "Number of Civil Wars") ) style(html) label replace collabels(, none) starlevels(* 0.1 ** 0.05 *** 0.01) eform prehead("<table>") postfoot("</table>")
est drop *

streg incompatibility type censip_* prox_sip_change_std election cendiff* lngdpcap lnpop Oil cenelf* if sample==1, dist(wei) tr
est store duration_multi_variate_20, title(T3_R2_C3)
streg incompatibility type presidential prop fedpol3 lngdpcap lnpop Oil cenelf* if sample2==1, dist(wei) tr
est store duration_multi_variate_21, title(T3_R1_C3)
streg incompatibility type  polityiv_std polity_sq_std prox_sip_change_std cendiff* lngdpcap lnpop cenelf* Oil if sample==1, dist(wei) tr
est store duration_multi_variate_22, title(T3_R3_C3)

streg incompatibility type censip_* prox_sip_change_std election cendiff* lngdpcap lnpop Oil cenelf* if sample==1 & maxintensity>1, dist(wei) tr
est store duration_multi_variate_20b, title(T3_R2_C3b)
streg incompatibility type presidential prop fedpol3 lngdpcap lnpop Oil cenelf* if sample2==1 & maxintensity>1, dist(wei) tr
est store duration_multi_variate_21b, title(T3_R1_C3b)
streg incompatibility type  polityiv_std polity_sq_std prox_sip_change_std cendiff* lngdpcap lnpop cenelf* Oil if sample==1 & maxintensity>1, dist(wei) tr
est store duration_multi_variate_22b, title(T3_R3_C3b)

estout duration_multi* using "duration_multi2.html", cells(b(star fmt(%9.3f)) t(par)) stats(ll ll_0 N N_sub N_fail, fmt(%9.2f %9.2f %9.0g %9.0g %9.0g) labels("Log Likelihood" "Log Likelihood null model" "N" "Number of Countries" "Number of Civil Wars") ) style(html) label replace collabels(, none) starlevels(* 0.1 ** 0.05 *** 0.01) eform prehead("<table>") postfoot("</table>")
